/* ----------------------------------------
Code exported from SAS Enterprise Guide
DATE: Monday, March 01, 2010     TIME: 9:31:19 AM
PROJECT: MyXMLintoSASparameterized
PROJECT PATH:
 C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp
---------------------------------------- */

/* Unable to determine code to assign library SGF on Local */
/* Unable to determine code to assign library SGF on Local */
/* Unable to determine code to assign library SGF on Local */

/* ---------------------------------- */
/* MACRO: enterpriseguide             */
/* PURPOSE: define a macro variable   */
/*   that contains the file system    */
/*   path of the WORK library on the  */
/*   server.  Note that different     */
/*   logic is needed depending on the */
/*   server type.                     */
/* ---------------------------------- */
%macro enterpriseguide;
%global sasworklocation;
%if &sysscp=OS %then %do; /* MVS Server */
	%if %sysfunc(getoption(filesystem))=MVS %then %do;
        /* By default, physical file name will be considered a classic MVS data
 set. */
	    /* Construct dsn that will be unique for each concurrent session under a
 particular account: */
		filename egtemp '&egtemp' disp=(new,delete); /* create a temporary data set */
 		%let tempdsn=%sysfunc(pathname(egtemp)); /* get dsn */
		filename egtemp clear; /* get rid of data set - we only wanted its name */
		%let unique_dsn=".EGTEMP.%substr(&tempdsn, 1, 16).PDSE"; 
		filename egtmpdir &unique_dsn
			disp=(new,delete,delete) space=(cyl,(5,5,50))
			dsorg=po dsntype=library recfm=vb
			lrecl=8000 blksize=8004 ;
		options fileext=ignore ;
	%end; 
 	%else %do; 
        /* 
		By default, physical file name will be considered an HFS 
		(hierarchical file system) file. 
		Note:  This does NOT support users who do not have an HFS home directory.
		It also may not support multiple simultaneous sessions under the same account.
		*/
		filename egtmpdir './';                          
	%end; 
	%let path=%sysfunc(pathname(egtmpdir));
        %let sasworklocation=%sysfunc(quote(&path));  
%end; /* MVS Server */
%else %do;
	%let sasworklocation = "%sysfunc(getoption(work))/";
%end;
%if &sysscp=VMS_AXP %then %do; /* Alpha VMS server */
	%let sasworklocation = "%sysfunc(getoption(work))";                         
%end;
%if &sysscp=CMS %then %do; 
	%let path = %sysfunc(getoption(work));                         
	%let sasworklocation = "%substr(&path, %index(&path,%str( )))";
%end;
%mend enterpriseguide;

%enterpriseguide

ODS PROCTITLE;
OPTIONS DEV=ACTIVEX;
GOPTIONS XPIXELS=0 YPIXELS=0;
FILENAME EGSRX TEMP;
ODS tagsets.sasreport12(ID=EGSRX) FILE=EGSRX STYLE=Analysis STYLESHEET=(URL=
"file:///C:/Program%20Files%20(x86)/SAS/SharedFiles/BIClientStyles/4.2/Analysis.css")
 NOGTITLE NOGFOOTNOTE GPATH=&sasworklocation ENCODING=UTF8 options(rolap="on");

/*   START OF NODE: libname   */
%LET _CLIENTTASKLABEL='libname';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;
libname sgf 'C:\DDRIVE\projects\sugs\SGF2010\ReadingXML\data';

options fmtsearch=(sgf);


GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;


/*   START OF NODE: Import from XML   */
%LET _CLIENTTASKLABEL='Import from XML';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;
/********************************************************************************
 *  Generated by XML Mapper, 902000.3.6.20090116170000_v920
 ********************************************************************************/

/*
 *  Environment
 */

%let inFolder = C:\DDRIVE\projects\sugs\SGF2010\ReadingXML\data\SUGI_SGF_files;

%let mapFolder = C:\DDRIVE\projects\sugs\SGF2010\ReadingXML\SAScode;

%let mapFile = SGF_030_2010_XMLmapUpdated.map;


filename  SUGISGF3 "&inFolder.\&XMLfile.";

filename  SXLEMAP "&mapFolder.\&mapFile.";

libname   SUGISGF3 xml xmlmap=SXLEMAP access=READONLY;



/*
 *  Catalog
 */

proc datasets lib=SUGISGF3; run;

/*
 *  Contents
 */

proc contents data=SUGISGF3.dta varnum; run;
proc contents data=SUGISGF3.header varnum; run;
proc contents data=SUGISGF3.descriptors varnum; run;
proc contents data=SUGISGF3.typelist varnum; run;
proc contents data=SUGISGF3.type varnum; run;
proc contents data=SUGISGF3.varlist varnum; run;
proc contents data=SUGISGF3.variable varnum; run;
proc contents data=SUGISGF3.srtlist varnum; run;
proc contents data=SUGISGF3.sort varnum; run;
proc contents data=SUGISGF3.fmtlist varnum; run;
proc contents data=SUGISGF3.fmt varnum; run;
proc contents data=SUGISGF3.lbllist varnum; run;
proc contents data=SUGISGF3.lblname varnum; run;
proc contents data=SUGISGF3.variable_labels varnum; run;
proc contents data=SUGISGF3.vlabel varnum; run;
proc contents data=SUGISGF3.expansion varnum; run;
proc contents data=SUGISGF3.char varnum; run;
proc contents data=SUGISGF3.data varnum; run;
proc contents data=SUGISGF3.o varnum; run;
proc contents data=SUGISGF3.v varnum; run;
proc contents data=SUGISGF3.value_labels varnum; run;
proc contents data=SUGISGF3.vallab varnum; run;
proc contents data=SUGISGF3.label varnum; run;

/*
 *  Printing
 */

title 'Table dta';
proc print data=SUGISGF3.dta(obs=30); run;
title;

title 'Table header';
proc print data=SUGISGF3.header(obs=30); run;
title;

title 'Table descriptors';
proc print data=SUGISGF3.descriptors(obs=30); run;
title;

title 'Table typelist';
proc print data=SUGISGF3.typelist(obs=30); run;
title;

title 'Table type';
proc print data=SUGISGF3.type(obs=30); run;
title;

title 'Table varlist';
proc print data=SUGISGF3.varlist(obs=30); run;
title;

title 'Table variable';
proc print data=SUGISGF3.variable(obs=30); run;
title;

title 'Table srtlist';
proc print data=SUGISGF3.srtlist(obs=30); run;
title;

title 'Table sort';
proc print data=SUGISGF3.sort(obs=30); run;
title;

title 'Table fmtlist';
proc print data=SUGISGF3.fmtlist(obs=30); run;
title;

title 'Table fmt';
proc print data=SUGISGF3.fmt(obs=30); run;
title;

title 'Table lbllist';
proc print data=SUGISGF3.lbllist(obs=30); run;
title;

title 'Table lblname';
proc print data=SUGISGF3.lblname(obs=30); run;
title;

title 'Table variable_labels';
proc print data=SUGISGF3.variable_labels(obs=30); run;
title;

title 'Table vlabel';
proc print data=SUGISGF3.vlabel(obs=30); run;
title;

title 'Table expansion';
proc print data=SUGISGF3.expansion(obs=30); run;
title;

title 'Table char';
proc print data=SUGISGF3.char(obs=30); run;
title;

title 'Table data';
proc print data=SUGISGF3.data(obs=30); run;
title;

title 'Table o';
proc print data=SUGISGF3.o(obs=30); run;
title;

title 'Table v';
proc print data=SUGISGF3.v(obs=30); run;
title;

title 'Table value_labels';
proc print data=SUGISGF3.value_labels(obs=30); run;
title;

title 'Table vallab';
proc print data=SUGISGF3.vallab(obs=30); run;
title;

title 'Table label';
proc print data=SUGISGF3.label(obs=30); run;
title;


/*
 *  Local Extraction
 */

DATA dta; SET SUGISGF3.dta; run;
DATA header; SET SUGISGF3.header; run;
DATA descriptors; SET SUGISGF3.descriptors; run;
DATA typelist; SET SUGISGF3.typelist; run;
DATA type; SET SUGISGF3.type; run;
DATA varlist; SET SUGISGF3.varlist; run;
DATA variable; SET SUGISGF3.variable; run;
DATA srtlist; SET SUGISGF3.srtlist; run;
DATA sort; SET SUGISGF3.sort; run;
DATA fmtlist; SET SUGISGF3.fmtlist; run;
DATA fmt; SET SUGISGF3.fmt; run;
DATA lbllist; SET SUGISGF3.lbllist; run;
DATA lblname; SET SUGISGF3.lblname; run;
DATA variable_labels; SET SUGISGF3.variable_labels; run;
DATA vlabel; SET SUGISGF3.vlabel; run;
DATA expansion; SET SUGISGF3.expansion; run;
DATA char; SET SUGISGF3.char; run;
DATA data; SET SUGISGF3.data; run;
DATA o; SET SUGISGF3.o; run;
DATA v; SET SUGISGF3.v; run;
DATA value_labels; SET SUGISGF3.value_labels; run;
DATA vallab; SET SUGISGF3.vallab; run;
DATA label; SET SUGISGF3.label; run;



GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;


/*   START OF NODE: restructure Data   */
%LET SYSLAST=WORK.V;
%LET _CLIENTTASKLABEL='restructure Data';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;
/* restructure the data table - all character variables */
                                     /* retrieve the number of variables as a
 macro variable  */
proc sql noprint;
select nvar into :nvars
from header;
                                     /* join all variable info  */
create table work.variableInfo as
select variable.varname,
       type.type,
       fmt.fmt,
       lblname.lblname,
       vlabel.vlabel,

       variable.variable_ORDINAL,
       type.type_ORDINAL,
       fmt.fmt_ORDINAL,
       lblname.lblname_ORDINAL,
       vlabel.vlabel_ORDINAL
from  variable,
       type,
       fmt,
       lblname,
       vlabel
where variable.varname=type.varname AND
       variable.varname=fmt.varname AND
       variable.varname=lblname.varname AND
       variable.varname=vlabel.varname
;

%put nvars=&nvars;
                                        /* create the transposed (all char vars)
 dataset  */
proc transpose data=work.v 
               out=work.vTransposed;
var v;
by o_ordinal;
run;

GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;


/*   START OF NODE: Col Attributes   */
%LET SYSLAST=WORK.CHAR;
%LET _CLIENTTASKLABEL='Col Attributes';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;
                                         /*  join proc format info */
proc SQL;
create table sgf.&DatasetName._CNTLIN as
 select name as fmtname,
       put(value,16.) as start,
	   label
 from work.vallab, work.label
 where vallab.vallab_ORDINAL = label.vallab_ORDINAL;


quit;

/* run the cntlin */
proc format library=sgf cntlin=sgf.&DatasetName._CNTLIN;
run;



                                 /* build an array of macro variables each
 containing */
                                 /* an attribute and assignment statment        
      */
                                 /* to create a named column from teh
 corresponding col<n> */
data _null_;
/* %- indicates left justified - will be ignored */  
%let nPatterns=20;
set work.variableInfo end=last;
length  SASformat $ 100 attribStmt assignStmt defStmt $ 2000;
                                         /*  array of PRX patterns with
 corresponding format root and number of  */
                                         /*  numeric elements in the format */
 array fmts {&nPatterns,3} $ 30 _temporary_ (
     '/^%-*(\d+)\.(\d+)g/'   'BEST'   '2'      /* g general to BEST  */
     '/^%-*(\d+)\.(\d+)f/'   ' '      '2'      /* f fixed  */
     '/^%-*(\d+)\.(\d+)e/'   'E',     '2'      /* e exponential  E */
     '/^%(\d+)x/'            'HEX'    '2'      /* x hexadecimal HEX  */

     '/^%(\d+)H/'            'BINARY' '1'      /* H hilo (binary) BINARY  */
     '/^%(\d+)L/'            'BEST'   '1'      /* L lohi (binary) no SAS format
 use HEX  */

     '/^%-*(\d+)\.(\d+)gc/'  'COMMA'  '2'     /* gc general (with commas) COMMA
 (would BEST be better  */
     '/^%-*(\d+)\.(\d+)fc/'  'COMMA'  '2'     /* fc fixed  (with commas) COMMA 
 */

     '/^%0(\d+)\.(\d+)f/'    'Z'      '2'     /* 0 f fixed (leading zeros) Z  */

     '/^%-*(\d+),(\d+)gc/'   'COMMAX' '2'      /* gc general (with commas as
 decimal separator) COMMAX (would BEST be better  */
     '/^%-*(\d+),(\d+)fc/'   'COMMAX' '2'        /* fc fixed  (with commas  as
 decimal separator) COMMAX  */
                                   
     '/^%t[cC]/'  'DATETIME'          '0'        /* tc or tC date/time DATETIME
 base milliseconds from 1JAN1960  */

     '/^%td/'  'DATE'                 '0'        /* td date/time DATETIME base
 days from 1JAN1960  */

     '/^%tw/'  'WEEKW'                '0'       /* tc or tC date/time WEEKW base
 weeks from 1JAN1960  */
     '/^%tm/'  'YYMM'                 '0'        /* tc or tC date/time YYMM base
 months from 1JAN1960  */
     '/^%tq/'  'YYQ'                  '0'         /* tc or tC date/time YYQ base
 quarters from 1JAN1960  */
     '/^%th/'  'YYQR'                 '0'        /* tc or tC date/time use
 YYQR???? base half-years from 1JAN1960  */

     '/^%ty/'  'BEST'                 '0'        /* tc or tC date/time BEST base
 years from 0  */
     '/^%tg/'  'BEST'                 '0'        /* tc or tC date/time BEST base
 generic from 1JAN1960  */

                                                 /* %- indicates left justified
 - will be ignored */  
                                                 /* %~ indicates centered -
 ignored */
     '/^%[-~]*(\d+)s/'  '$'           '1'        /* s string $   */
  
    );

  array prxIDs {&nPatterns} _TEMPORARY_;

  if _n_=1 then do ixPattern = 1 to &nPatterns;
    prxIDs{ixPattern} = prxParse(fmts{ixPattern,1});
  end;

  do ixPattern = 1 to &nPatterns;
    if prxmatch(prxIDs{ixPattern},fmt) then do;
      select ( fmts{ixPattern,3} );                            /* how many
 numeric components */
          when ('2')  SASformat = cats(fmts{ixPattern,2},               
                                       prxposn(prxIDs{ixPattern}, 1, fmt),
                                       '.',
                                       prxposn(prxIDs{ixPattern}, 2, fmt),
                                       '.'
                                       );
          when ('1')  SASformat = cats(fmts{ixPattern,2},               
                                       prxposn(prxIDs{ixPattern}, 1, fmt),
                                       '.'
                                       );

         otherwise     SASformat = cats(fmts{ixPattern,2}, 
                                        '.'
                                        );
      end; /* select */
                                                    /*  If BEST is the preferred
 format just use length 16  */
      if fmts{ixPattern,2} = 'BEST' then SASformat = 'BEST16.';

      if fmts{ixPattern,2} = '$' then do;
        
        SASlength = catx(' ',  '$',  prxposn(prxIDs{ixPattern}, 1, fmt)  );
      end;
      else do;
        SASlength = '8';
      end;

    end; /* if prxmatch */
  end; /*  do ixPattern */

  if lblname ne ' ' then SASformat = cats(lblname,'.');
                                                        /* clean varname and
 vlabel */

                                                        /* build macro variable
 content  */
                                                      /* ATTRIBUTES */
  attribStmt = catx(' ',
                    'ATTRIB',
                    varname,
                    'FORMAT',
                    '=',
                    SASformat,
                    'LENGTH',
                    '=',
                    SASlength,
                    'LABEL',
                    '=',
                    cats("'",  vlabel,  "'"),
                    ';'
                    );
                                                      /* ASSIGNMENT statement */
                                                      /* NOTE some date/time
 constructs need to be rescaled */


  if  SASlength = '8' then do;    /* numeric variable */
    assignStmt = catx(' ',
                      varname,
                      cats('= put(COL', 
                           put(variable_ORDINAL,16.),
                           ',16.)'  
                          )   ,
                      ';'
                     );
  end;
  else do;                        /*  string variable */
    assignStmt = catx(' ',
                      varname,
                      cats('= COL', 
                           put(variable_ORDINAL,16.)  
                           )   ,
                      ';'
                     );
  end;

 
                                                      /*  assign a macro
 variable "array" element */
 
 call symput(cats('C_' , put(variable_ORDINAL,7.)  ) ,
             catx(' ',  attribStmt , assignStmt)  
            ); 

 if last then call symput('NVARS',strip(put(variable_ORDINAL,7.) ) );

 run;

    /* echo the last macro var NOTE, the embedded semicolon will generate an
 error

 %put last var is number &NVARS,  C_&NVARS = &&C_&NVARS;

   */

                  /*  Use the macro vars to rename variables with attributes
 applied  */
 %macro restructure;
data sgf.&DatasetName.;
  set work.vtransposed ;
  drop _NAME_ _LABEL_ COL1-COL&NVARS;

  %DO IXV = 1 %TO &NVARS;
   &&C_&IXV;
   
  %END;
 run;
%mend restructure;  

%restructure;
 


                  /*  sort the dataset as specified in work.sort  */

proc sql noprint;
 select varname into :sortBy separated by ' '
 from work.sort
 where varname ne ' ';
  quit;
%put sortBy = &sortBy;


                        /*  get the first sort variable name */
proc sql noprint;
 select varname into :FirstSortVar
 from work.sort
 where sort_ORDINAL=1;
 quit;
 %put FirstSortVar = &FirstSortVar;


                        /* sort the file if there is at least one sort variable
 */
%macro SortFile();
%IF &FirstSortVar NE   %THEN %DO;
proc sort data=sgf.&DatasetName.;
  by &sortBy;
run;
%END;
%mend SortFile;
%sortFile();


/*
proc contents data=sgf.&DatasetName.;
run;
*/

                                         /* make a table with the metadata that
 */
                                         /* can't be stored in the SAs dataset 
 */
proc sql;
 create table sgf.&DatasetName._Other as
   select char.vname as object,
          case 
           when char.vname = '_dta' then "Dataset: &DatasetName."
           else variableInfo.vlabel
          end as objectLabel,
          char.name as characteristicType,
          char.char as characteristic

   from work.char left join work.variableInfo on
     char.vname = variableInfo.varname 
   where      char.char ne '1'
   order by object;
quit;


GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;


/*   START OF NODE: Program1   */
%LET _CLIENTTASKLABEL='Program1';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;
GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;


/*   START OF NODE: Program   */
%LET _CLIENTTASKLABEL='Program';
%LET _CLIENTPROJECTPATH=
'C:\DDrive\projects\sugs\SGF2010\ReadingXML\SAScode\MyXMLintoSASparameterized.egp';
%LET _CLIENTPROJECTNAME='MyXMLintoSASparameterized.egp';
%LET _SASPROGRAMFILE=;

GOPTIONS ACCESSIBLE;



GOPTIONS NOACCESSIBLE;
%LET _CLIENTTASKLABEL=;
%LET _CLIENTPROJECTPATH=;
%LET _CLIENTPROJECTNAME=;
%LET _SASPROGRAMFILE=;

;*';*";*/;quit;run;
ODS _ALL_ CLOSE;
